unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DirNavigator01, StdCtrls, ExtCtrls, Grids, Menus;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    StringGrid1: TStringGrid;
    stxtChoiceDir: TStaticText;
    Panel1: TPanel;
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    procedure RunOnChangeDir(Sender: TObject);
    procedure ListBoxDriveListClick(Sender: TObject);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

var ListBoxDriveList : TListBoxDriveList;
    DirNavigator     : TDirNavigator;
    Indicator        : TIndicator;

procedure TForm1.FormCreate(Sender: TObject);
begin

    ListBoxDriveList := TListBoxDriveList.Create(ListBox1);
    DirNavigator     := TDirNavigator.Create(StringGrid1);
    ListBox1.OnClick := ListBoxDriveListClick;
    DirNavigator.OnChangeDir := RunOnChangeDir;
    Indicator        := TIndicator.Create(Image1);
    DirNavigator.Indicator := Indicator;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   DirNavigator.Free;
   ListBoxDriveList.Free;
end;

// --------------------------------------------------------------------
//  
// --------------------------------------------------------------------
//   OnChangeDir  DirNavigator
procedure TForm1.RunOnChangeDir(Sender: TObject);
begin
   stxtChoiceDir.Caption := (Sender as TDirNavigator).ChoiceDir;
end;
// --------------------------------------------------------------------
//     
procedure TForm1.ListBoxDriveListClick(Sender: TObject);
var DriveChar : char;
begin
  //    TistBoxDriveList  TDirNavigator
  if Assigned(ListBoxDriveList) and Assigned(DirNavigator)
  then  begin
     if not ListBox1.ItemIndex < 0
     then begin
        //    ComboBox1  
        DriveChar := ListBoxDriveList.DriveChar[ListBox1.ItemIndex];
        //     
        DirNavigator.ChoiceDir := DriveChar + ':'
     end;
  end;
end;

end.
